/*
 * Decompiled with CFR 0.152.
 */
package jace.core;

import jace.config.Reconfigurable;
import jace.core.CPU;
import jace.core.Keyboard;
import jace.core.RAM;
import jace.core.Video;
import java.io.IOException;

public abstract class Computer
implements Reconfigurable {
    private static Computer theComputer;
    public RAM memory;
    public CPU cpu;
    public Video video;
    public Keyboard keyboard;

    public Computer() {
        theComputer = this;
        this.keyboard = new Keyboard();
    }

    public RAM getMemory() {
        return this.memory;
    }

    public abstract void notifyVBLStateChanged(boolean var1);

    public void setMemory(RAM memory) {
        this.memory = memory;
    }

    public void waitForNextCycle() {
    }

    public Video getVideo() {
        return this.video;
    }

    public void setVideo(Video video) {
        this.video = video;
    }

    public CPU getCpu() {
        return this.cpu;
    }

    public void setCpu(CPU cpu) {
        this.cpu = cpu;
    }

    public void loadRom(String path) throws IOException {
        this.memory.loadRom(path);
    }

    public abstract void coldStart();

    public abstract void warmStart();

    public static Computer getComputer() {
        return theComputer;
    }

    public Keyboard getKeyboard() {
        return this.keyboard;
    }
}

